/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#pragma once
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Windows.h>
#include <TlHelp32.h>
#include <string.h>

#include <Psapi.h>

#ifdef _WIN64
	#define memlong long long
	#define min_mem_location 0x0
	#define max_mem_location 0xFFFFFFFFFFFFFFFF
	#define default_buffer_size 1024*1024*512 //Een halve gig
	#define default_buffer_overflow_size 1024*1024 //Een mb
	#define default_empty_overflow_size 1024 //Een kb
#else //32 bit
	#define memlong long
	#define min_mem_location 0x0 //0x00400000
	#define max_mem_location 0xFFFFFFFF //0x7FFFFFFF
	#define default_buffer_size 1024*1024*512 //Een halve gig
	#define default_buffer_overflow_size 1024*1024 //Een mb
	#define default_empty_overflow_size 1024 //Een kb
#endif



typedef struct DUMP_SESSION {
	HANDLE dumpFile;
	HANDLE optionalDumpFile;
	int unlocated_size;
	char* string_location;
	char* zerobuf;
	int flags;
	void* freePointer;
} DUMP_SESSION;

typedef DUMP_SESSION* (* InitiateFilter)(char* location, char* argument, int analyse_type);
typedef int (* MEMFUNC)(void* param, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize);
typedef void (* Destroy)(DUMP_SESSION* filter);

typedef struct MEMFUNC_STRUCT {
	struct MEMFUNC_STRUCT* next;
	MEMFUNC func;
	Destroy funcDestroy;
	void* param;
	int flags;
} MEMFUNC_STRUCT;


DWORD FindProcess(char *name, DWORD nextProcess);
void Destroy_MemoryDump(DUMP_SESSION* dumpsess);
DUMP_SESSION* CreateMemoryDump(char* outputDir, char* outputFile, char* optionalOutputFile, int flags);
DUMP_SESSION* CreateUNICODEMemoryDump(char* outputDir, char* outputFile, char* optionalOutputFile, int flags);
int searchFile(HANDLE inputFile, MEMFUNC_STRUCT* memf);
void showError(int code);
void showLastError();

#define DS_WRITE_UNREADABLE_DATA_TO_DUMP 0x1
#define DS_WRITE_LOCATION_STRING 0x2

#define ANALYSE_FILE 0x1
#define ANALYSE_MEMORY 0x2

#define MS_RETURN_ON_ZERO 0x1
#define MS_RETURN_NOT_ZERO 0x2

#define ARGUMENT_PID 0x0
#define ARGUMENT_FILE 0x1
#define ARGUMENT_LOCATION 0x2
#define ARGUMENT_FSU 0x3 
#define ARGUMENT_FPA 0x4
#define ARGUMENT_FCA 0x5
#define ARGUMENT_GUA 0x6
#define ARGUMENT_GUU 0x7
#define ARGUMENT_SD 0x8
#define ARGUMENT_BD 0x9
#define ARGUMENT_SSA 0xA
#define ARGUMENT_SRA 0xB
#define ARGUMENT_SCA 0xC
#define ARGUMENT_IUA 0xD
#define ARGUMENT_IUU 0xE
#define ARGUMENT_ICA 0xF